% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.simple_table}
\alias{\%merge\%}
\alias{merge.simple_table}
\title{Merge two tables/data.frames}
\usage{
x \%merge\% y
}
\arguments{
\item{x}{data.frame or results of \code{fre}/\code{cro_*}}

\item{y}{data.frame or results of \code{fre}/\code{cro_*}}
}
\value{
data.frame
}
\description{
\code{\%merge\%} is infix shortcut for base \link[base]{merge} with 
\code{all.x = TRUE} and  \code{all.y = FALSE} (left join). There is also 
special method for combining results of \code{cro_*} and \code{fre}. For them
\code{all = TRUE} (full join). It allows make complex tables from simple
ones. See examples. Strange result is possible if one or two arguments have
duplicates in first column (column with labels).
}
\examples{
data(mtcars)
# apply labels
mtcars = modify(mtcars,{
                var_lab(mpg) = "Miles/(US) gallon"
                var_lab(cyl) = "Number of cylinders"
                var_lab(disp) = "Displacement (cu.in.)"
                var_lab(hp) = "Gross horsepower"
                var_lab(drat) = "Rear axle ratio"
                var_lab(wt) = "Weight (lb/1000)"
                var_lab(qsec) = "1/4 mile time"
                var_lab(vs) = "V/S"
                val_lab(vs) = c("V-engine" = 0, "Straight engine" = 1)
                var_lab(am) = "Transmission (0 = automatic, 1 = manual)"
                val_lab(am) = c(automatic = 0, manual = 1)
                var_lab(gear) = "Number of forward gears"
                var_lab(carb) = "Number of carburetors"
})

# table by 'am'
tab1 = with(mtcars, cro_cpct(gear, am))
# table with percents
tab2 = with(mtcars, cro_cpct(gear, vs))

# combine tables
# \%n_d\% remove first total
tab1 \%n_d\% "#Total" \%merge\% tab2
}
\seealso{
\link{fre}, \link{cro}, \link[base]{merge}
}

