% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/where.R
\name{where}
\alias{.where}
\alias{\%where\%}
\alias{where}
\title{Subsetting Data Frames}
\usage{
where(data, cond)

data \%where\% cond

.where(cond)
}
\arguments{
\item{data}{data.frame to be subsetted}

\item{cond}{logical or numeric expression indicating elements or rows to
keep: missing values (NA) are taken as false.}
}
\value{
data.frame which contains just selected rows.
}
\description{
\code{cond} will be evaluated in the context of the data frame, so columns can be referred to (by
name) as variables in the expression (see the examples).
\code{.where} is version for working with default dataset. See \link{default_dataset}.
 \code{\%where\%} is infix function with the same functional. See examples. There is a 
special constant \code{.n} which equals to number of cases in \code{data} for
usage in \code{cond} expression.
}
\examples{
# leave only 'setosa'
where(iris, Species == "setosa")
# leave only first five rows
where(iris, 1:5)

# infix version
# note that '\%where\%' have higher precendence than '=='
# so we need to put condition inside brackets
iris \%where\% (Species == "setosa")

iris \%where\% 1:5

# example of .n usage. Very artificial examples
set.seed(42)
train = iris \%where\% sample(.n, 100)
str(train)

set.seed(42)
test = iris \%where\% -sample(.n, 100)
str(test)
}

