% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtfrm.R
\name{sheet}
\alias{sheet}
\alias{as.sheet}
\alias{dtfrm}
\alias{as.dtfrm}
\alias{lst}
\alias{.dtfrm}
\alias{.sheet}
\alias{.lst}
\title{Make data.frame without conversion to factors and without fixing names}
\usage{
sheet(...)

as.sheet(x, ...)

dtfrm(...)

as.dtfrm(x, ...)

lst(...)

.dtfrm(...)

.sheet(...)

.lst(...)
}
\arguments{
\item{...}{objects, possibly named}

\item{x}{object to be coerced to data.frame}
}
\value{
data.frame/list
}
\description{
\code{sheet} and \code{as.sheet} are shortcuts to \code{data.frame} and 
\code{as.data.frame} with stringsAsFactors = FALSE, check.names = FALSE.
\code{lst} creates list with names.
\code{.sheet}, \code{.lst} the same as above but work in the scope of default
dataset.
}
\examples{

# see the difference
df1 = data.frame(a = letters[1:3], "This is my long name" = 1:3)
df2 = sheet(a = letters[1:3], "This is my long name" = 1:3)

str(df1)
str(df2)

# lst
a = 1:3
b = 3:1

list1 = list(a, b)
list2 = lst(a, b)

str(list1)
str(list2)

data(iris)
default_dataset(iris)

.sheet(Sepal.Width,  Sepal.Length)
.lst(Sepal.Width,  Sepal.Length)

}
\seealso{
\link{default_dataset}, \link[base]{data.frame}, \link[base]{as.data.frame}, 
 \link[base]{list}
}
