% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expConcat.R
\name{expConcat}
\alias{expConcat}
\title{Concatenate rows of matching experiments}
\usage{
expConcat(e1, e2, name = NULL, tol = 1e-09)
}
\arguments{
\item{e1}{First experiment object to concat.}

\item{e2}{Second experiment object to concat. Must have the same configuration
than e1.}

\item{name}{Optional name, if not provided the new experiment will be called
"e1_name + e2_name"}

\item{tol}{Tolerance value for duplicate checking.}
}
\value{
An experiment object having all the rows of e1 and e2
}
\description{
This function concatenates two experiments with the same configuration
of parameter an outputs. At least one common output must be present,
the rest of them will be removed from the resulting experiment.
Different methods and problems can be present.
}
\examples{
# In this example we turn the wekaExperiment into two different experiments,
# with different parameter values to combine them:

df_no  <- wekaExperiment[wekaExperiment$featureSelection=="no",]
df_yes <- wekaExperiment[wekaExperiment$featureSelection=="yes",]

exp_yes <- expCreate(df_yes, name="fss-yes", parameter="fold")
exp_no <- expCreate(df_no, name="fss-no", parameter="fold")

expConcat(exp_yes, exp_no)
}

