% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta-binomial-distribution.R
\name{BetaBinom}
\alias{BetaBinom}
\alias{dbbinom}
\alias{pbbinom}
\alias{rbbinom}
\title{Beta-Binomial distribution}
\usage{
dbbinom(x, size, alpha = 1, beta = 1, log = FALSE)

pbbinom(q, size, alpha = 1, beta = 1, lower.tail = TRUE, log.p = FALSE)

rbbinom(n, size, alpha = 1, beta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{size}{number of trials (zero or more).}

\item{alpha, beta}{non-negative parameters of the beta distribution.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the Beta-binomial distribution.
}
\details{
Probability mass function
\deqn{
f(x) = {n \choose x} \frac{\mathrm{B}(x+\alpha, n-x+\beta)}{\mathrm{B}(\alpha, \beta)}
}{
f(x) = choose(n, x) * (beta(x+alpha, n-x+beta)) / (beta(alpha, beta))
}
}
\examples{

x <- rbbinom(1e5, 1000, 5, 13)
xx <- 0:1000
hist(x, 100, freq = FALSE)
lines(xx-0.5, dbbinom(xx, 1000, 5, 13), col = "red")
hist(pbbinom(x, 1000, 5, 13))
plot(ecdf(x))
lines(xx, pbbinom(xx, 1000, 5, 13), col = "red", lwd = 2)

}
\seealso{
\code{\link[stats]{Beta}}, \code{\link[stats]{Binomial}}
}
\keyword{distribution}

