% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomial-distribution.R
\name{Multinomial}
\alias{Multinomial}
\alias{dmnom}
\alias{rmnom}
\title{Multinomial distribution}
\usage{
dmnom(x, size, prob, log = FALSE)

rmnom(n, size, prob)
}
\arguments{
\item{x}{\eqn{k}-column matrix of quantiles.}

\item{size}{numeric vector; number of trials (zero or more).}

\item{prob}{\eqn{k}-column numeric matrix; probability of success on each trial.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the multinomial distribution.
}
\details{
Probability mass function
\deqn{
f(x) = \frac{n!}{\prod_{i=1}^k x_i} \prod_{i=1}^k p_i^{x_i}
}{
f(x) = n!/prod(x[i]!) * prod(p[i]^x[i])
}
}
\examples{

# Generating 10 random draws from multinomial distribution
# parametrized using a vector

(x <- rmnom(10, 3, c(1/3, 1/3, 1/3)))

# Results are consistent with dmultinom() from stats:

all.equal(dmultinom(x[1,], 3, c(1/3, 1/3, 1/3)),
          dmnom(x[1, , drop = FALSE], 3, c(1/3, 1/3, 1/3)))

}
\references{
Gentle, J.E. (2006). Random number generation and Monte Carlo methods. Springer.
}
\seealso{
\code{\link[stats]{Binomial}}, \code{\link[stats]{Multinomial}}
}
\keyword{distribution}
