% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-gamma-distribution.R
\name{DiscreteGamma}
\alias{DiscreteGamma}
\alias{ddgamma}
\alias{pdgamma}
\alias{rdgamma}
\title{Discrete gamma distribution}
\usage{
ddgamma(x, shape, rate = 1, scale = 1/rate, log = FALSE)

pdgamma(q, shape, rate = 1, scale = 1/rate, lower.tail = TRUE,
  log.p = FALSE)

rdgamma(n, shape, rate = 1, scale = 1/rate)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape, scale}{shape and scale parameters. Must be positive, scale strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function, distribution function and random generation
for discrete gamma distribution.
}
\details{
Probability mass function of discrete gamma distribution \eqn{f_Y(y)}{f}
is defined by discretization of continuous gamma distribution
\eqn{f_Y(y) = S_X(y) - S_X(y+1)}{f(y) = S(x) - S(x+1)}
where \eqn{S_X}{S} is a survival function of continous gamma distribution.
}
\examples{

x <- rdgamma(1e5, 9, 1)
xx <- 0:50
plot(prop.table(table(x)))
lines(xx, ddgamma(xx, 9, 1), col = "red")
hist(pdgamma(x, 9, 1))
plot(ecdf(x))
xx <- seq(0, 50, 0.1)
lines(xx, pdgamma(xx, 9, 1), col = "red", lwd = 2, type = "s")

}
\references{
Chakraborty, S. and Chakravarty, D. (2012).
Discrete Gamma distributions: Properties and parameter estimations.
Communications in Statistics-Theory and Methods, 41(18), 3301-3324.
}
\seealso{
\code{\link[stats]{GammaDist}}, \code{\link{DiscreteNormal}}
}
\concept{
Univariate

Discrete
}
\keyword{distribution}
