\name{subtree}
\alias{subtree}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
subtrees
}
\description{
Takes a subtree of a dendrogram object such as generated by \link[stats]{hclust} according to a prespecified number of clusters or a prespecified height.
}
\usage{
subtree(tree, k = NULL, h = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{tree}{
The tree object which contains the attributes \code{merge} and \code{height} in the same way as an \link[stats]{hclust} object.
}
  \item{k}{
The number of clusters at which to cut.
}
  \item{h}{
The height at which to cut.
}
}
\details{
Does the same as \link[stats]{cutree} with two differences: Firstly it gives back an entire tree object, i.e. an object with attributes \code{merge}, \code{height}, \code{labels}  and \code{order}, as well as \code{data}, which contains the cluster ids. Secondly the cluster ids are chosen by the heights at which the clusters were built.
}
\value{
An \link[stats]{hclust} object.
}

\author{
Alexander Pilhoefer
}


\seealso{
\link[stats]{cutree} 
}
\examples{
hc <- hclust(dist(USArrests), "ave")

hcs <- subtree(hc, k = 7)
hcs2 <- subtree(hc, h= 30)

attributes(hcs)
fluctile(table(hcs$data, cutree(hc, k=7)))

par(mfrow=c(1,3))
plot(hc)
plot(hcs)
plot(hcs2)

}

