\name{embed_fonts}
\alias{embed_fonts}
\title{Embeds fonts that are listed in the local Fontmap}
\usage{
embed_fonts(file, format, outfile = file, options = "")
}
\arguments{
  \item{file}{Name of input file.}

  \item{outfile}{Name of the output file (with fonts
  embedded). (Default is same as input file)}

  \item{format}{File format. (see \code{?embedFonts})}

  \item{options}{Other arguments passed to
  \code{embedFonts}.}
}
\description{
Embeds fonts that are listed in the local Fontmap
}
\examples{
\donttest{
loadfonts()
pdf('fonttest.pdf')
library(ggplot2)

p <- ggplot(mtcars, aes(x=wt, y=mpg)) + geom_point()

# Run only the code below that is appropriate for your system
# On Mac and Windows, Impact should be available
p + opts(axis.title.x=theme_text(size=16, family="Impact", colour="red"))

# On Linux, Purisa may be available
p + opts(axis.title.x=theme_text(size=16, family="Purisa", colour="red"))
dev.off()

embed_fonts('fonttest.pdf', outfile='fonttest-embed.pdf')
}
}
\seealso{
\code{\link{loadfonts}}
}

