% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{res_student}
\alias{res_student}
\title{Student's t Residuals}
\usage{
res_student(x, mean = 0, sd = 1, theta = 0, type = "dev", simulate = FALSE)
}
\arguments{
\item{x}{A non-negative whole numeric vector of values.}

\item{mean}{A numeric vector of the means.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture models (student, gamma-Poisson and beta-binomial).}

\item{type}{A string of the residual type. 'raw' for raw residuals 'dev' for deviance residuals and 'data' for the data.}

\item{simulate}{A flag specifying whether to simulate residuals.}
}
\value{
An numeric vector of the corresponding residuals.
}
\description{
Student's t Residuals
}
\examples{
res_student(c(1,3.5,4), mean = 6, sd = 0.5, theta = 1/3, type = "raw")
}
\seealso{
Other res_dist: 
\code{\link{res_bern}()},
\code{\link{res_beta_binom}()},
\code{\link{res_binom}()},
\code{\link{res_gamma_pois_zi}()},
\code{\link{res_gamma_pois}()},
\code{\link{res_gamma}()},
\code{\link{res_lnorm}()},
\code{\link{res_neg_binom}()},
\code{\link{res_norm}()},
\code{\link{res_pois_zi}()},
\code{\link{res_pois}()}
}
\concept{res_dist}
