% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\alias{parameters}
\alias{arguments}
\alias{args}
\title{Parameter Descriptions}
\arguments{
\item{...}{Other arguments passed to methods.}

\item{alpha}{The first shape parameter of the Beta distribution.}

\item{beta}{The second shape parameter of the Beta distribution.}

\item{conf_level}{A numeric scalar between 0 and 1 specifying the confidence
level.}

\item{directional}{A flag specifying whether probabilities less than 0.5
should be returned as negative values.}

\item{lambda}{A non-negative numeric vector of means.}

\item{log}{A flag specifying whether to return the log-transformed value.}

\item{lower.tail}{A flag specifying whether to return the lower or upper tail
of the distribution.}

\item{mean}{A numeric vector of the means.}

\item{meanlog}{A numeric vector of the means on the log scale.}

\item{n}{A non-negative whole number of the number of random samples to
generate.}

\item{na_rm}{A flag specifying whether to remove missing values.}

\item{nas}{A flag specifying whether to also fill missing values.}

\item{p}{A vector of probabilities.}

\item{prob}{A numeric vector of values between 0 and 1 of the probability of
success.}

\item{q}{A vector of quantiles.}

\item{rate}{A non-negative numeric vector of rate.}

\item{res}{A flag specifying whether to return the deviance residual as
opposed to the deviance.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}

\item{sdlog}{A non-negative numeric vector of the standard deviations on the
log scale.}

\item{shape}{A non-negative numeric vector of shape.}

\item{simulate}{A flag specifying whether to simulate residuals.}

\item{size}{A non-negative whole numeric vector of the number of trials.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture
models (student, gamma-Poisson and beta-binomial).}

\item{threshold}{A number of the threshold value.}

\item{type}{A string of the residual type. 'raw' for raw residuals 'dev' for
deviance residuals and 'data' for the data.}

\item{value}{A scalar of the value to replace values with.}

\item{x}{An object.}
}
\description{
Default parameter descriptions which may be overridden in individual
functions.
}
\details{
A flag is a non-missing logical scalar.

A string is a non-missing character scalar.
}
\keyword{internal}
