% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{res_neg_binom}
\alias{res_neg_binom}
\title{Negative Binomial Residuals}
\usage{
res_neg_binom(x, lambda = 1, theta = 0, type = "dev", simulate = FALSE)
}
\arguments{
\item{x}{A non-negative whole numeric vector of values.}

\item{lambda}{A non-negative numeric vector of means.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture
models (student, gamma-Poisson and beta-binomial).}

\item{type}{A string of the residual type. 'raw' for raw residuals 'dev' for
deviance residuals and 'data' for the data.}

\item{simulate}{A flag specifying whether to simulate residuals.}
}
\value{
An numeric vector of the corresponding residuals.
}
\description{
Negative Binomial Residuals
}
\examples{
res_neg_binom(c(0, 1, 5), 2, 3)
}
\seealso{
Other res_dist: 
\code{\link{res_bern}()},
\code{\link{res_beta_binom}()},
\code{\link{res_binom}()},
\code{\link{res_gamma}()},
\code{\link{res_gamma_pois}()},
\code{\link{res_gamma_pois_zi}()},
\code{\link{res_lnorm}()},
\code{\link{res_norm}()},
\code{\link{res_pois}()},
\code{\link{res_pois_zi}()},
\code{\link{res_skewnorm}()},
\code{\link{res_student}()}
}
\concept{res_dist}
