% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_before.R
\name{step_date_before}
\alias{step_date_before}
\alias{tidy.step_date_before}
\title{Time before Recurrent Date Time Event}
\usage{
step_date_before(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  rules = list(),
  transform = "identity",
  columns = NULL,
  skip = FALSE,
  id = rand_id("date_before")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{rules}{Named list of \code{almanac} rules.}

\item{transform}{A function or character indication a function used oon the
resulting variables. See details for allowed names and their functions.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{\link[recipes:prep]{recipes::prep.recipe()}} is used.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new check added to the
sequence of any existing operations.
}
\description{
\code{step_date_before()} creates a \emph{specification} of a recipe step that will
create new columns indicating the time before an recurrent event.
}
\details{
The \code{transform} argument can be function that takes a numeric vector and
returns a numeric vector of the same length. It can also be a character
vector, below is the supported vector names. Some functions come with offset
to avoid \code{Inf}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{"identity"
function(x) x

"inverse"
function(x) 1 / (x + 0.5)

"exp"
function(x) exp(x)

"log"
function(x) log(x + 0.5)
}\if{html}{\out{</div>}}

The effect of \code{transform} is illustrated below.

\figure{date_before-1.png}\figure{date_before-2.png}\figure{date_before-3.png}\figure{date_before-4.png}

The naming of the resulting variables will be on the form

\if{html}{\out{<div class="sourceCode r">}}\preformatted{\{variable name\}_before_\{name of rule\}
}\if{html}{\out{</div>}}
}
\examples{
library(recipes)
library(extrasteps)
library(almanac)
library(modeldata)

data(Chicago)

on_easter <- yearly() \%>\% recur_on_easter()
on_weekend <- weekly() \%>\% recur_on_weekends()

rules <- list(easter = on_easter, weekend = on_weekend)

rec_spec <- recipe(ridership ~ date, data = Chicago) \%>\%
  step_date_before(date, rules = rules)

rec_spec_preped <- prep(rec_spec)

bake(rec_spec_preped, new_data = NULL)
}
