% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers-radf.R
\name{tidy.radf}
\alias{tidy.radf}
\alias{augment.radf}
\alias{glance.radf}
\title{Tidy an radf object}
\usage{
\method{tidy}{radf}(x, format = c("wide", "long"), ...)

\method{augment}{radf}(x, format = c("wide", "long"), panel = FALSE,
  ...)

\method{glance}{radf}(x, format = c("wide", "long"), ...)
}
\arguments{
\item{x}{An \code{radf} object}

\item{format}{Long or wide format}

\item{...}{Additional arguments. Not used.}

\item{panel}{Either univariate or panel bsadf.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}
}
\description{
Tidy an radf object
}
\examples{
\dontrun{
dta <- data.frame(psy1 = sim_psy1(n = 100), psy2 = sim_psy2(n = 100))

rfd <- radf(data)

# Get the t-stat
tidy(rfd)

# Get the t-stat sequences
augment(rfd)

# Get the panel t-stat
glance(mc)
}
}
