% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_sum.R
\name{csums}
\alias{csums}
\title{Sum matrix columns and assign name to resulting row}
\usage{
csums(df, row_name = NULL)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{row_name}{String, name to assign to resulting row.}
}
\value{
A row matrix (with rows and column names)
}
\description{
Improved version of \code{colSums()} for matrix output. The sum of columns is
kept as a row vector with column names and the resulting row can be
named in the same command.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
csums(wio$Y, "TOTAL_Y")
}
