% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_mult.R
\name{multd}
\alias{multd}
\title{Multiply a matrix by a diagonal matrix}
\usage{
multd(matrix1, matrix2)
}
\arguments{
\item{matrix1}{An ordinary matrix.}

\item{matrix2}{A diagonal matrix.}
}
\value{
The product of matrix1 and matrix2.
}
\description{
Fast multiplication of a matrix by a diagonal matrix, taking advantage
of the properties of diagonal matrices.
}
\details{
\code{multd()} will turn \code{matrix2} into a vector and multiply it
horizontally by every row in \code{matrix1}. This saves precious computing
time.\
The number of columns of \code{matrix1} must be equal to the rows and
columns of diagonal \code{matrix2}.
}
\examples{
wio <- make_wio("wiodtest")
multd(wio$B, wio$E)
}
\seealso{
\code{\link[=dmult]{dmult()}}.
}
