% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{va_chart}
\alias{va_chart}
\title{Visual acuity conversion chart}
\format{
A data frame with 29 rows and 5 variables:
\describe{
\item{snellenft}{snellen VA in feet}
\item{snellenm}{snellen VA in meter}
\item{snellendec}{decimal snellen VA}
\item{logmar}{logMAR VA}
\item{etdrs}{VA in ETDRS letters}
\item{quali}{VA categories}
}
}
\usage{
data("va_chart")
}
\description{
Conversion between snellen, logMAR and ETDRS.
Snellen feet, meter and decimal supported. Three qualitative common
vision measures included (light perception, hand movement and
counting fingers). Further details for conversion used can be found in
\link{va} and \link{va_methods}
}
\seealso{
\itemize{
\item This chart and VA conversion formulas are based on charts in
Holladay et al.\doi{10.1016/j.jcrs.2004.01.014}, Beck et al.
\doi{10.1016/s0002-9394(02)01825-1}{Beck et al.}, and
Gregori et al.\doi{10.1097/iae.0b013e3181d87e04}.
}

Categories \strong{(no) light perception},  \strong{counting fingers}
and \strong{hand movements} are converted following
Schulze-Bonsel et al. (https://doi.org/10.1167/iovs.05-0981)
and \href{https://michaelbach.de/sci/acuity.html}{Michael Bach's suggestions}
}
\keyword{datasets}
