% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_spline_data.R
\name{analyze_boot_splines}
\alias{analyze_boot_splines}
\alias{analyze_boot_splines.boot_splines_data}
\title{Estimate confidence intervals for bootstrapped splines data}
\usage{
analyze_boot_splines(data)

\method{analyze_boot_splines}{boot_splines_data}(data)
}
\arguments{
\item{data}{The output of the \code{boot_splines_data} function}
}
\value{
A dataframe indicating means and CIs for each time-bin
}
\description{
Deprecated. Performing this analysis should be done by calling \code{analyze_time_bins(test="boot_splines")}.
}
\details{
Estimates a confidence interval over the difference between means (within- or between-subjects)
from \code{boot_splines_data}. Confidence intervals are derived from the alpha argument in 
\code{boot_splines_data} (e.g., alpha = .05, CI=(.025,.975); alpha=.01, CI=(.005,.0995))
}
\section{Methods (by class)}{
\itemize{
\item \code{boot_splines_data}: 
}}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE )
response_window <- subset_by_window(data, window_start_time = 15500, window_end_time = 21000, 
                                    rezero = FALSE)
response_time <- make_time_sequence_data(response_window, time_bin_size = 500, aois = "Animate", 
                                         predictor_columns = "Sex", 
                                         summarize_by = "ParticipantName")
                                         
# bootstrap resample 500 smoothed splines from the dataset,
# comparing females versus females at an alpha of .05                                         
df_bootstrapped <- make_boot_splines_data(response_time,
                                          predictor_column = 'Sex',
                                          within_subj = FALSE,
                                          bs_samples = 500,
                                          alpha = .05,
                                          smoother = "smooth.spline")

# analyze the divergences that occurred
boot_splines_analysis <- analyze_boot_splines(df_bootstrapped)
summary(boot_splines_analysis)

}

