% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_models.R
\name{show_models}
\alias{show_models}
\title{Show Cox Models}
\usage{
show_models(
  models,
  model_names = NULL,
  covariates = NULL,
  merge_models = FALSE,
  drop_controls = FALSE,
  headings = list(variable = "Variable", n = "N", measure = "Hazard ratio", ci = NULL,
    p = "p"),
  ...
)
}
\arguments{
\item{models}{a \code{ezcox_models} from \code{\link[=get_models]{get_models()}} or a (named) list of Cox models.}

\item{model_names}{model names to show when \code{merge_models=TRUE}.}

\item{covariates}{a character vector optionally listing the variables to include in the plot (defaults to all variables).}

\item{merge_models}{if 'TRUE', merge all models and keep the plot tight.}

\item{drop_controls}{works when \code{covariates=NULL} and \code{models} is a \code{ezcox_models}, if \code{TRUE},
it removes control variables automatically.}

\item{headings}{a \code{list} for setting the heading text.}

\item{...}{other arguments passing to \code{\link[forestmodel:forest_model]{forestmodel::forest_model()}}.}
}
\value{
a \code{ggplot} object
}
\description{
Show Cox Models
}
\examples{
library(survival)
zz <- ezcox(lung, covariates = c("sex", "ph.ecog"), controls = "age", return_models = TRUE)
mds <- get_models(zz)
show_models(mds)
show_models(mds, model_names = paste0("Model ", 1:2))
show_models(mds, covariates = c("sex", "ph.ecog"))
show_models(mds, drop_controls = TRUE)
show_models(mds, merge_models = TRUE)
show_models(mds, merge_models = TRUE, drop_controls = TRUE)
}
