% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezgrp.R
\name{ezcox_group}
\alias{ezcox_group}
\title{Group Cox Analysis and Visualization}
\usage{
ezcox_group(
  data,
  grp_var,
  covariate,
  controls = NULL,
  time = "time",
  status = "status",
  sort = FALSE,
  decreasing = TRUE,
  add_all = FALSE,
  add_caption = TRUE,
  verbose = TRUE,
  headings = list(variable = "Group", n = "N", measure = "Hazard ratio", ci = NULL, p =
    "p"),
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables, time and os status.}

\item{grp_var}{a group column.}

\item{covariate}{a covariable for cox analysis.}

\item{controls}{column names specifying controls.}

\item{time}{column name specifying time, default is 'time'.}

\item{status}{column name specifying event status, default is 'status'.}

\item{sort}{if \code{TRUE}, sort the models by the HR values.}

\item{decreasing}{logical, should the sort order be increasing or decreasing?}

\item{add_all}{if \code{TRUE}, add a group for all data rows.}

\item{add_caption}{if \code{TRUE}, add caption to the plot.}

\item{verbose}{if \code{TRUE}, print extra info.}

\item{headings}{a \code{list} for setting the heading text.}

\item{...}{other arguments passing to \code{\link[forestmodel:forest_model]{forestmodel::forest_model()}}.}
}
\value{
a \code{list}.
}
\description{
Group Cox Analysis and Visualization
}
\examples{
library(survival)
ezcox_group(lung, grp_var = "sex", covariate = "ph.ecog")
ezcox_group(lung, grp_var = "sex", covariate = "ph.ecog", controls = "age")
p <- ezcox_group(lung,
  grp_var = "sex", covariate = "ph.ecog",
  controls = "age", add_all = TRUE
)
}
