% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezcox.R
\name{ezcox}
\alias{ezcox}
\title{Run Cox Analysis in Batch Mode}
\usage{
ezcox(
  data,
  covariates,
  controls = NULL,
  time = "time",
  status = "status",
  global_method = c("likelihood", "wald", "logrank"),
  keep_models = FALSE,
  return_models = FALSE,
  model_dir = file.path(tempdir(), "ezcox"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables, time and os status.}

\item{covariates}{column names specifying variables.}

\item{controls}{column names specifying controls.
The names with pattern "*:|()" will be treated as interaction/combination
term, please make sure all column names in \code{data} are valid R variable names.}

\item{time}{column name specifying time, default is 'time'.}

\item{status}{column name specifying event status, default is 'status'.}

\item{global_method}{method used to obtain global p value for cox model,
should be one of "likelihood", "wald", "logrank".
The likelihood-ratio test, Wald test, and score logrank statistics.
These three methods are asymptotically equivalent. For large enough N,
they will give similar results. For small N, they may differ somewhat.
The Likelihood ratio test has better behavior for small sample sizes,
so it is generally preferred.}

\item{keep_models}{If \code{TRUE}, keep models as local files.}

\item{return_models}{default \code{FALSE}. If \code{TRUE}, return a \code{list} contains
cox models.}

\item{model_dir}{a path for storing model results.}

\item{verbose}{if \code{TRUE}, print extra info.}

\item{...}{other parameters passing to \code{\link[survival:coxph]{survival::coxph()}}.}
}
\value{
a \code{ezcox} object
}
\description{
Run Cox Analysis in Batch Mode
}
\examples{
library(survival)

# Build unvariable models
t1 <- ezcox(lung, covariates = c("age", "sex", "ph.ecog"))
t1

# Build multi-variable models
# Control variable 'age'
t2 <- ezcox(lung, covariates = c("sex", "ph.ecog"), controls = "age")
t2

# Return models
t3 <- ezcox(lung,
  covariates = c("age", "sex", "ph.ecog"),
  return_models = TRUE
)
t3
t4 <- ezcox(lung,
  covariates = c("sex", "ph.ecog"), controls = "age",
  return_models = TRUE
)
t4
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
