% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_plot.R
\name{variable_plot}
\alias{variable_plot}
\title{variable_plot}
\usage{
variable_plot(
  data,
  x,
  y,
  group = NULL,
  facet_x = NULL,
  size = 14,
  labels_y = ez_labels,
  geom = "line",
  size_line = 1,
  ylab = NULL,
  yoy = FALSE,
  switch = "y",
  rescale_y = 1
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{labels_y}{label formatting function}

\item{geom}{Either "line", "col" or "bar". Default is "line"}

\item{size_line}{width of line for \code{geom_line()}. Default is 1.}

\item{ylab}{y label text}

\item{yoy}{Logical used to indicate whether a YOY grouping should be created.
Default is \code{FALSE}.}

\item{switch}{Option to switch location of variable (facet) labels. Default
is 'y' (yes) which shows facet strips on left side of panels.}

\item{rescale_y}{Rescaling factor for y-axis limits}
}
\description{
Plots variables (multiple "y" values) broken out as vertical
  facets.
}
\examples{
library(tsibbledata)
variable_plot(ansett, "Week", "Passengers", facet_x = "Class")
variable_plot(ansett, "Week", "Passengers", facet_x = "Class", yoy = TRUE)
variable_plot(pelt, "Year", c("Lynx", "Hare"), "round(Year, -1)")
variable_plot(hh_budget, "Year", c("Debt", "Expenditure"), "Country")
variable_plot(PBS, "Type", "Scripts", "Concession", switch = "y", geom = "col")
variable_plot(subset(hh_budget, Year > 2013), "Year",
              c("Debt\n(\% of disposable income)" = "Debt",
                "Expenditure\nGrowth (\%)" = "Expenditure",
                "Unemployment (\%)" = "Unemployment"),
               facet_x = "Country", geom = "bar")
variable_plot(subset(hh_budget, Year > 2013), "Year",
              c("Debt\n(\% of disposable income)" = "Debt",
                "Expenditure\nGrowth (\%)" = "Expenditure",
                "Unemployment (\%)" = "Unemployment"),
               group = "Country", geom = "bar")
}
