% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_T_star.R
\name{compute_T_star}
\alias{compute_T_star}
\title{Compute lengths of fine-scale chunks}
\usage{
compute_T_star(horizon, period, dates = NULL, seed = NULL)
}
\arguments{
\item{horizon}{The element \code{controls$horizon}, i.e., an integer vector of length 2,
where the second entry can be \code{NA_integer_}.}

\item{period}{The element \code{controls$period}, i.e. one of \code{"w"},
\code{"m"}, \code{"q"}, or \code{"y"}.}

\item{dates}{A \code{character} vector of dates of empirical fine-scale data (if any).
By default, \code{dates = NULL}.}

\item{seed}{Set a seed for the simulation of flexible chunk lengths.
By default, \code{seed = NULL} (i.e., no seed).}
}
\value{
An \code{integer} vector of fine-scale chunk sizes.
}
\description{
This helper function computes lengths of fine-scale chunks in the
hierarchical case.
}
\examples{
\dontrun{
### weekly fine-scale chunk sizes for 10 coarse-scale observations
horizon <- c(10, NA_integer_)
period <- "w"
compute_T_star(horizon, period)
}

}
\keyword{internal}
