#' First Example Time Series from the ABIDE
#'
#' A sagittal slice from the fMRI time series for subject 0050048. The scan was
#'  obtained at the University of Pittsburgh School of Medicine. The scan has
#'  been pre-processed with slice time correction, rigid body realignment
#'  estimation, spatial normalization to MNI space, and linear detrending. 
#'  Subject 0050048 was a typically-developing 11-year-old male. The scan has
#'  many artifacts. A mask was applied to vectorize the spatial 
#'  dimensions. 
#' 
#'  Source: http://fcon_1000.projects.nitrc.org/indi/abide/abide_I.html
#'
#' @format A numeric matrix of 193 time points by 4675 voxels
#' @section References:
#'  \itemize{
#'    \item{1.Di Martino, A. et al. The autism brain imaging data exchange: towards a large-scale evaluation of the intrinsic brain architecture in autism. Mol Psychiatry 19, 659–667 (2014).}
#' }
"Dat1"

#' Second Example Time Series from the ABIDE
#'
#' A sagittal slice from the fMRI time series for subject 0051479. The scan was 
#'  obtained at the California Institute of Technology. The scan has
#'  been pre-processed with slice time correction, rigid body realignment
#'  estimation, spatial normalization to MNI space, and linear detrending. 
#'  Subject 0051479 was a typically-developing 20-year-old female. The scan has 
#'  few visible artifacts. A mask was applied to vectorize the spatial 
#'  dimensions. 
#' 
#'  Source: http://fcon_1000.projects.nitrc.org/indi/abide/abide_I.html
#' 
#' @format A numeric matrix of 145 time points by 4679 voxels
#' @section References:
#'  \itemize{
#'    \item{1.Di Martino, A. et al. The autism brain imaging data exchange: towards a large-scale evaluation of the intrinsic brain architecture in autism. Mol Psychiatry 19, 659–667 (2014).}
#' }
"Dat2"
