% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrub.R
\name{scrub_xifti}
\alias{scrub_xifti}
\title{Scrub fMRI data in CIFTI format}
\usage{
scrub_xifti(
  X,
  method = c("projection", "DVARS"),
  brainstructures = c("left", "right"),
  ...
)
}
\arguments{
\item{X}{Path to a CIFTI file, or a \code{"xifti"} object.}

\item{method}{\code{"projection"} or \code{"DVARS"}}

\item{brainstructures}{Character vector indicating which brain structure(s)
to use: \code{"left"} (left cortical surface), \code{"right"} (right
cortical surface) and/or \code{"subcortical"} (subcortical and cerebellar
gray matter). Can also be \code{"all"} (obtain all three brain structures).
Default: \code{c("left", "right")} (excludes the subcortex).}

\item{...}{Additional arguments to each specific scrubbing function:
\code{\link{pscrub}} or \code{\link{DVARS}}.}
}
\value{
A list with components
\describe{
\item{measure}{A length \eqn{T} vector or data.frame with \eqn{T} rows, giving the outlyingness measure(s)}
\item{measure_info}{Describes the outlyingness measure(s)}
\item{outlier_cutoff}{The outlier cutoff value(s).}
\item{outlier_flag}{A length \eqn{T} vector or data.frame with \eqn{T} rows,  where \code{TRUE} indicates suspected outlier presence.}
}
}
\description{
Performs projection scrubbing or DVARS scrubbing, and optionally thresholds
to identify artifactual time points. Requires \code{ciftiTools} and the
Connectome Workbench.
}
