% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croston.R
\name{forecast.croston}
\alias{forecast.croston}
\title{Forecast a model from the fable package}
\usage{
\method{forecast}{croston}(object, new_data, specials = NULL, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{...}{Other arguments passed to methods}
}
\value{
A list of forecasts.
}
\description{
Produces forecasts from a trained model.
}
\examples{
library(tsibble)
sim_poisson <- tsibble(
  time = yearmonth("2012 Dec") + seq_len(24),
  count = rpois(24, lambda = 0.3),
  index = time
)

sim_poisson \%>\%
  model(CROSTON(count)) \%>\%
  forecast()
}
