% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvsim.R
\name{covmat.fsvsim}
\alias{covmat.fsvsim}
\title{Extract "true" model-implied covariance matrix for several points in time}
\usage{
\method{covmat}{fsvsim}(x, timepoints = "all", ...)
}
\arguments{
\item{x}{Object of class \code{'fsvsim'}, usually resulting from a call
of the function \code{\link{fsvsim}}.}

\item{timepoints}{Vector indicating at which point(s) in time the
correlation matrices should be extracted. Can also be "all" or "last".}

\item{...}{Ignored.}
}
\value{
Array of dimension \code{m} times \code{m} times
\code{length(timepoints)}, containing the model-implied covariance matrix.
}
\description{
\code{covmat} extracts the model-implied (time-varying) covariance matrix
from an \code{fsvsim} object.
}
\note{
Currently crudely implemented as an R loop over all time points,
may be slow.
}
\seealso{
Other simulation: 
\code{\link{corelement}()},
\code{\link{cormat.fsvsim}()},
\code{\link{covelement}()}
}
\concept{simulation}
