% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{facloadtraceplot}
\alias{facloadtraceplot}
\title{Trace plots of factor loadings draws}
\usage{
facloadtraceplot(
  x,
  fsvsimobj = NULL,
  thinning = NULL,
  maxrows = 10,
  ylim = NULL
)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{fsvsimobj}{To indicate data generating values in case of simulated
data, pass an object of type \code{fsvsim} (usually the result of a
call to \code{\link{fsvsim}}).}

\item{thinning}{Plot every \code{thinning}th draw.}

\item{maxrows}{Indicates the maximum number of rows to be drawn per page.}

\item{ylim}{Vector of length two containing lower and upper bounds of the
vertical axis. If \code{NULL}, these are automatically determined.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{facloadtraceplot} draws trace plots of the factor loadings. Can be
an important tool to check MCMC convergence if inference about (certain)
factor loadings sought.
}
\seealso{
Other plotting: 
\code{\link{comtimeplot}()},
\code{\link{corimageplot}()},
\code{\link{corplot}()},
\code{\link{cortimeplot}()},
\code{\link{evdiag}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{logvartimeplot}()},
\code{\link{paratraceplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()},
\code{\link{voltimeplot}()}
}
\concept{plotting}
