% Generated by roxygen2 (4.0.1): do not edit by hand
\name{or}
\alias{\%||\%}
\alias{or}
\title{Robust 'or' operator working with truthy and falsy values.}
\usage{
lhs \%||\% rhs
}
\arguments{
\item{lhs}{Left hand side, always evaluated.}

\item{rhs}{Right hand side, only evaluated if \code{lhs}
evaluates to FALSY.}
}
\description{
Robust 'or' operator working with truthy and falsy values.
}
\examples{
\donttest{
## Set colors from colorspace package with a fallback
col <- try(colorspace::rainbow_hcl(5), silent = TRUE) \%||\% rainbow(5)

## Simpler with silent try
col <- try_quietly(colorspace::rainbow_hcl(5)) \%||\% rainbow(5)

## Message if foobar is not installed
try_quietly(library(foobar)) \%||\% message("no foobar")

## Message if list is empty
l <- list(1,2,3)
l \%||\% message("list is empty")

l <- list()
l \%||\% message("list is empty")
}
}

