% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParseSettings.R
\name{.parse_setup_settings}
\alias{.parse_setup_settings}
\title{Internal function for parsing settings related to the computational setup}
\usage{
.parse_setup_settings(
  config = NULL,
  parallel = waiver(),
  parallel_nr_cores = waiver(),
  restart_cluster = waiver(),
  cluster_type = waiver(),
  backend_type = waiver(),
  server_port = waiver(),
  ...
)
}
\arguments{
\item{config}{A list of settings, e.g. from an xml file.}

\item{parallel}{(\emph{optional}) Enable parallel processing. Defaults to \code{TRUE}.
When set to \code{FALSE}, this disables all parallel processing, regardless of
specific parameters such as \code{parallel_preprocessing}. However, when
\code{parallel} is \code{TRUE}, parallel processing of different parts of the
workflow can be disabled by setting respective flags to \code{FALSE}.}

\item{parallel_nr_cores}{(\emph{optional}) Number of cores available for
parallelisation. Defaults to 2. This setting does nothing if
parallelisation is disabled.}

\item{restart_cluster}{(\emph{optional}) Restart nodes used for parallel computing
to free up memory prior to starting a parallel process. Note that it does
take time to set up the clusters. Therefore setting this argument to \code{TRUE}
may impact processing speed. This argument is ignored if \code{parallel} is
\code{FALSE} or the cluster was initialised outside of familiar. Default is
\code{FALSE}, which causes the clusters to be initialised only once.}

\item{cluster_type}{(\emph{optional}) Selection of the cluster type for parallel
processing. Available types are the ones supported by the parallel package
that is part of the base R distribution: \code{psock} (default), \code{fork}, \code{mpi},
\code{nws}, \code{sock}. In addition, \code{none} is available, which also disables
parallel processing.}

\item{backend_type}{(\emph{optional}) Selection of the backend for distributing
copies of the data. This backend ensures that only a single master copy is
kept in memory. This limits memory usage during parallel processing.

Several backend options are available, notably \code{socket_server}, and \code{none}
(default). \code{socket_server} is based on the callr package and R sockets,
comes with \code{familiar} and is available for any OS. \code{none} uses the package
environment of familiar to store data, and is available for any OS.
However, \code{none} requires copying of data to any parallel process, and has a
larger memory footprint.}

\item{server_port}{(\emph{optional}) Integer indicating the port on which the
socket server or RServe process should communicate. Defaults to port 6311.
Note that ports 0 to 1024 and 49152 to 65535 cannot be used.}

\item{...}{Unused arguments.}
}
\value{
List of parameters related to the computational setup.
}
\description{
Internal function for parsing settings related to the computational setup
}
\keyword{internal}
