% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataParameterChecks.R
\name{.update_initial_settings}
\alias{.update_initial_settings}
\title{Internal check and update of settings related to data set parsing}
\usage{
.update_initial_settings(
  formula = NULL,
  data,
  settings,
  check_stringency = "strict"
)
}
\arguments{
\item{formula}{User-provided formula, may be absent (\code{NULL}).}

\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{settings}{List of parameter settings for data set parsing.}

\item{check_stringency}{Specifies stringency of various checks. This is mostly:
\itemize{
\item \code{strict}: default value used for \code{summon_familiar}. Thoroughly checks
input data. Used internally for checking development data.
\item \code{external_warn}: value used for \code{extract_data} and related methods. Less
stringent checks, but will warn for possible issues. Used internally for
checking data for evaluation and explanation.
\item \code{external}: value used for external methods such as \code{predict}. Less
stringent checks, particularly for identifier and outcome columns, which may
be completely absent. Used internally for \code{predict}.
}}
}
\value{
A verified and updated list of parameter settings.
}
\description{
This function updates and checks parameters related to data set parsing based
on the available data set.
}
\keyword{internal}
