% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{familiarData-class}
\alias{familiarData-class}
\title{Dataset obtained after evaluating models on a dataset.}
\description{
A familiarData object is created by evaluating familiarEnsemble or
familiarModel objects on a dataset. Multiple familiarData objects are
aggregated in a familiarCollection object.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the dataset, e.g. training or internal validation.}

\item{\code{outcome_type}}{Outcome type of the data used to create the object.}

\item{\code{outcome_info}}{Outcome information object, which contains additional
information concerning the outcome, such as class levels.}

\item{\code{fs_vimp}}{Variable importance data collected from feature selection
methods.}

\item{\code{model_vimp}}{Variable importance data collected from model-specific
algorithms implemented by models created by familiar.}

\item{\code{permutation_vimp}}{Data collected for permutation variable importance.}

\item{\code{hyperparameters}}{Hyperparameters collected from created models.}

\item{\code{hyperparameter_data}}{Additional data concerning hyperparameters. This is
currently not used yet.}

\item{\code{required_features}}{The set of features required for complete
reproduction, i.e. with imputation.}

\item{\code{model_features}}{The set of features that are required for using the
model or ensemble of models, but without imputation.}

\item{\code{learner}}{Learning algorithm used to create the model or ensemble of
models.}

\item{\code{fs_method}}{Feature selection method used to determine variable
importance for the model or ensemble of models.}

\item{\code{pooling_table}}{Run table for the data underlying the familiarData
object. Used internally.}

\item{\code{prediction_data}}{Model predictions for a model or ensemble of models for
the underlying dataset.}

\item{\code{confusion_matrix}}{Confusion matrix for a model or ensemble of models,
based on the underlying dataset.}

\item{\code{decision_curve_data}}{Decision curve analysis data for a model or
ensemble of models, based on the underlying dataset.}

\item{\code{calibration_info}}{Calibration information, e.g. baseline survival in the
development cohort.}

\item{\code{calibration_data}}{Calibration data for a model or ensemble of models,
based on the underlying dataset.}

\item{\code{model_performance}}{Model performance data for a model or ensemble of
models, based on the underlying dataset.}

\item{\code{km_info}}{Information concerning risk-stratification cut-off values..}

\item{\code{km_data}}{Kaplan-Meier survival data for a model or ensemble of models,
based on the underlying dataset.}

\item{\code{auc_data}}{AUC-ROC and AUC-PR data for a model or ensemble of models,
based on the underlying dataset.}

\item{\code{ice_data}}{Individual conditional expectation data for features included
in a model or ensemble of models, based on the underlying dataset. Partial
dependence data are computed on the fly from these data.}

\item{\code{univariate_analysis}}{Univariate analysis of the underlying dataset.}

\item{\code{feature_expressions}}{Feature expression values of the underlying
dataset.}

\item{\code{feature_similarity}}{Feature similarity information of the underlying
dataset.}

\item{\code{sample_similarity}}{Sample similarity information of the underlying
dataset.}

\item{\code{is_validation}}{Signifies whether the underlying data forms a validation
dataset. Used internally.}

\item{\code{generating_ensemble}}{Name of the ensemble that was used to generate the
familiarData object.}

\item{\code{project_id}}{Identifier of the project that generated the familiarData
object.}

\item{\code{familiar_version}}{Version of the familiar package.

familiarData objects contain information obtained by evaluating a single
model or single ensemble of models on a dataset.}
}}

