/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.HashMap;
import java.util.Map;
import jfm.model.Formula;
import jfm.model.Operation;
import jfm.model.Types;
import jfm.utils.JFMMath;
import jfm.xml.FarmParser;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.TextConverter;
import jfm.xml.TextParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

final class OperationParser
extends JFMObjectParser {
    Types.OperationType type;

    public OperationParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("type", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("workability", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("mingap", JFMObjectParser.optionalAttribute);
        this.registerAttribute("nonsequential", JFMObjectParser.optionalAttribute);
        this.registerAttribute("handover", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLSyntaxException, XMLObjectException {
        block26: {
            FarmParser top = (FarmParser)this.getRootParent();
            try {
                int numPeriods = Integer.parseInt(top.getNamedAttribute("nperiods"));
                this.type = Types.xmlToOperationType(this.getNamedAttribute("type"));
                Types.WorkabilityType workability = Types.xmlToWorkabilityType(this.getNamedAttribute("workability"));
                int[] perAllow = null;
                Map<Object, Object> numMachines = null;
                Types.WorkerType firstMachine = Types.WorkerType.NOMACHINE;
                Formula wkrateF = null;
                double[] yieldpenalt = null;
                double[] costpenalt = null;
                double[] minareabyperiod = null;
                block11: for (int i = 0; i < this.getParserList("csv").size(); ++i) {
                    TextParser textp = (TextParser)this.getParserList("csv").get(i);
                    if (textp.dataType == null) continue;
                    switch (textp.dataType) {
                        case ALLOW: {
                            perAllow = TextConverter.toPeriods(textp.getCSV(), numPeriods);
                            continue block11;
                        }
                        case YIELDPENALTIES: {
                            yieldpenalt = TextConverter.toDouble(textp.getCSV());
                            int pen = 0;
                            while (pen < yieldpenalt.length) {
                                int n = pen++;
                                yieldpenalt[n] = yieldpenalt[n] * 0.01;
                            }
                            continue block11;
                        }
                        case COSTPENALTIES: {
                            costpenalt = TextConverter.toDouble(textp.getCSV());
                            continue block11;
                        }
                        case MINAREA: {
                            minareabyperiod = TextConverter.toDouble(textp.getCSV());
                            int pen = 0;
                            while (pen < minareabyperiod.length) {
                                int n = pen++;
                                minareabyperiod[n] = minareabyperiod[n] * 0.01;
                            }
                            continue block11;
                        }
                        case WKRATE: {
                            wkrateF = new Formula((String)textp.obj);
                            continue block11;
                        }
                        case MACHINES: {
                            numMachines = TextConverter.toNumMachines(textp.getCSV());
                            firstMachine = (Types.WorkerType)((Object)numMachines.keySet().iterator().next());
                            continue block11;
                        }
                        default: {
                            throw new XMLSyntaxException("The csv type " + (Object)((Object)textp.dataType) + " is not valid for the operation tag");
                        }
                    }
                }
                if (perAllow == null) {
                    throw new XMLSyntaxException(" you must specify allowed periods for each operation");
                }
                if (yieldpenalt == null) {
                    yieldpenalt = new double[perAllow.length];
                    JFMMath.doubleZero(yieldpenalt);
                }
                if (costpenalt == null) {
                    costpenalt = new double[perAllow.length];
                    JFMMath.doubleZero(costpenalt);
                }
                if (numMachines == null || wkrateF == null) {
                    if (numMachines == null && wkrateF == null) {
                        numMachines = new HashMap();
                    } else {
                        throw new XMLSyntaxException("If numMachines or workrate are defined then both must be defined");
                    }
                }
                int gap = 0;
                if (this.attributeHasValue("mingap")) {
                    gap = Integer.parseInt(this.getNamedAttribute("mingap"));
                }
                this.obj = new Operation(this.type, numPeriods, workability, wkrateF, numMachines, gap, firstMachine);
                Operation objalias = (Operation)this.obj;
                objalias.setYieldPenalties(perAllow, yieldpenalt);
                objalias.setCostPenalties(perAllow, costpenalt);
                if (minareabyperiod != null) {
                    objalias.setMinAreas(perAllow, minareabyperiod);
                }
                if (this.attributeHasValue("handover")) {
                    String val = this.getNamedAttribute("handover");
                    if (val.equals("true")) {
                        objalias.setHandOver();
                    } else {
                        throw new XMLSyntaxException("handover should only be set to true but was " + val);
                    }
                }
                if (!this.attributeHasValue("nonsequential")) break block26;
                String val = this.getNamedAttribute("nonsequential");
                if (val.equals("true")) {
                    objalias.setNonSequential();
                    break block26;
                }
                throw new XMLSyntaxException("nonsequential should only be set to true but was " + val);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                throw new XMLSyntaxException(ex.getMessage());
            }
            catch (XMLSyntaxException ex) {
                ex.printStackTrace();
                throw new XMLSyntaxException(ex.getMessage());
            }
        }
    }

    public String toString() {
        return "OperationParser";
    }

    public String parsesNode() {
        return "operation";
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        if (this.type != null) {
            return this.type.xmlname;
        }
        if (this.attributeHasValue("type")) {
            try {
                return this.getNamedAttribute("type");
            }
            catch (XMLObjectException ex) {
                throw new Error(ex.getMessage());
            }
        }
        return "operation";
    }
}

