% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_daily_cumulative_stats.R
\name{calc_daily_cumulative_stats}
\alias{calc_daily_cumulative_stats}
\title{Calculate cumulative daily flow statistics}
\usage{
calc_daily_cumulative_stats(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  percentiles = c(5, 25, 75, 95),
  use_yield = FALSE,
  basin_area,
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  transpose = FALSE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{percentiles}{Numeric vector of percentiles to calculate. Set to \code{NA} if none required. Default \code{c(5,25,75,95)}.}

\item{use_yield}{Logical value indicating whether to calculate area-based water yield, in mm, instead of volumetric discharge. 
Default \code{FALSE}.}

\item{basin_area}{Upstream drainage basin area, in square kilometres, to apply to observations. Three options:

(1) Leave blank if \code{groups} is STATION_NUMBER with HYDAT station numbers to extract basin areas from HYDAT.

(2) A single numeric value to apply to all observations.

(3) List each basin area for each group/station in groups (can override HYDAT value if listed) as such \code{c("08NM116" = 795, 
"08NM242" = 10)}. If group is not listed the HYDAT area will be applied if it exists, otherwise it will be \code{NA}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{months}{Numeric vector of months to add cumulative flows (e.g. \code{6:8} for Jun-Aug). Leave blank to accumulate 
all months (default \code{1:12}). Need to be consecutive months for given year/water year to work properly.}

\item{transpose}{Logical value indicating whether to transpose rows and columns of results. Default \code{FALSE}.}
}
\value{
A data frame with the following columns, default units in cubic metres, millimetres if use_yield and basin_area provided:
  \item{Date}{date (MMM-DD) of daily cumulative statistics}
  \item{DayofYear}{day of year of daily cumulative statistics}
  \item{Mean}{daily mean of all cumulative flows for a given day of the year}
  \item{Median}{daily mean of all cumulative flows for a given day of the year}
  \item{Maximum}{daily mean of all cumulative flows for a given day of the year}
  \item{Minimum}{daily mean of all cumulative flows for a given day of the year}
  \item{P'n'}{each daily n-th percentile selected of all cumulative flows for a given day of the year}
  Default percentile columns:
  \item{P5}{daily 5th percentile of all cumulative flows for a given day of the year}
  \item{P25}{daily 25th percentile of all cumulative flows for a given day of the year}
  \item{P75}{daily 75th percentile of all cumulative flows for a given day of the year}
  \item{P95}{daily 95th percentile of all cumulative flows for a given day of the year}
  Transposing data creates a column of "Statistics" and subsequent columns for each year selected.
}
\description{
Calculate cumulative daily flow statistics for each day of the year of daily flow values from a daily streamflow 
   data set. Defaults to volumetric cumulative flows, can use \code{use_yield} and \code{basin_area} to convert to area-based 
   water yield. Calculates statistics from all values from all complete years, unless specified. Returns a tibble with statistics.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Calculate annual daily cumulative yield statistics 
# with default HYDAT basin area
calc_daily_cumulative_stats(station_number = "08NM116",
                            use_yield = TRUE) 

# Calculate annual daily cumulative yield statistics 
# with custom basin area
calc_daily_cumulative_stats(station_number = "08NM116",
                            use_yield = TRUE,
                            basin_area = 800) 
                            
}
}
