% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\docType{class}
\name{fastglcm}
\alias{fastglcm}
\title{GLCM feature texture extraction}
\usage{
# init <- fastglcm$new()
}
\description{
GLCM feature texture extraction

GLCM feature texture extraction
}
\section{Methods}{



\describe{
 \item{\code{fastglcm$new()}}{}

 \item{\code{--------------}}{}

 \item{\code{GLCM_compute()}}{}

 \item{\code{--------------}}{}
}
}

\examples{

\dontrun{

require(fastGLCM)
require(OpenImageR)

file_im = system.file('images', 'Sugar_Cane_Bolivia_PlanetNICFI.png', package = 'fastGLCM')
im = readImage(file_im)

#...................................
# convert to gray and make sure that
# pixel values are between 0 and 255
#...................................

im = rgb_2gray(im)
im = im * 255

MIN = min(as.vector(im))
MAX = max(as.vector(im))

#...............
# methods to use
#...............

methods_py = c('mean',
               'std',
               'contrast',
               'dissimilarity',
               'homogeneity',
               'ASM_Energy',
               'max',
               'entropy')

init = fastglcm$new()

lst_glcm_py = list()

for (item_m in methods_py) {

  cat(paste0('Method: ', item_m), '\n')

  res_item = init$GLCM_compute(img = im,
                               method = item_m,
                               vmin = as.integer(MIN),
                               vmax = as.integer(MAX),
                               levels = as.integer(8),
                               ks = as.integer(5),
                               distance = 1.0,
                               angle = 0.0)

  lst_glcm_py[[item_m]] = res_item
}

#..............................
# Create two different sublists
# for 'ASM' and 'Energy'
#..............................

lst_glcm_py = append(lst_glcm_py, list(lst_glcm_py[['ASM_Energy']][[1]]), after = 5)
names(lst_glcm_py)[6] = 'ASM'

lst_glcm_py = append(lst_glcm_py, list(lst_glcm_py[['ASM_Energy']][[2]]), after = 6)
names(lst_glcm_py)[7] = 'Energy'

lst_glcm_py[['ASM_Energy']] = NULL

str(lst_glcm_py)

#.........................
# multi-plot of the output
#.........................

plot_multi_images(list_images = lst_glcm_py,
                  par_ROWS = 2,
                  par_COLS = 5,
                  titles = names(lst_glcm_py))
}
}
\references{
https://github.com/tzm030329/GLCM
https://github.com/1044197988/Python-Image-feature-extraction
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{fastglcm$new()}}
\item \href{#method-GLCM_compute}{\code{fastglcm$GLCM_compute()}}
\item \href{#method-clone}{\code{fastglcm$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialization method for the 'fastglcm' R6 class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fastglcm$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GLCM_compute"></a>}}
\if{latex}{\out{\hypertarget{method-GLCM_compute}{}}}
\subsection{Method \code{GLCM_compute()}}{
The GLCM computation method to receive the results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fastglcm$GLCM_compute(
  img,
  method,
  vmin = 0,
  vmax = 255,
  levels = 8,
  ks = 5,
  distance = 1,
  angle = 0,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{img}}{a numeric matrix}

\item{\code{method}}{a character string specifying the method. Can be one of 'mean', 'std', 'contrast', 'dissimilarity', 'homogeneity', 'ASM_Energy', 'max' or 'entropy'}

\item{\code{vmin}}{a numeric value specifying the minimum value of the input image ( \emph{img} )}

\item{\code{vmax}}{a numeric value specifying the maximum value of the input image ( \emph{img} )}

\item{\code{levels}}{an integer specifying the window size. This parameter will create a mask of size \emph{levels x levels} internally}

\item{\code{ks}}{an integer specifying the kernel size. A kernel of 1's will be created and the \emph{cv2.filter2D} filter will be utilized for the convolution}

\item{\code{distance}}{a numeric value specifying the pixel pair distance offsets (a 'pixel' value such as 1.0, 2.0 etc.)}

\item{\code{angle}}{a numeric value specifying the pixel pair angles (a 'degree' value such as 0.0, 30.0, 45.0, 90.0 etc.)}

\item{\code{verbose}}{a boolean. If TRUE then information will be printed out in the console}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list object if the method is set to 'ASM_Energy' otherwise a numeric matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fastglcm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
