% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{intmat_to_fmm}
\alias{intmat_to_fmm}
\title{Convert a Numeric Matrix to Matrix Market Format}
\arguments{
\item{input}{A numeric matrix to be converted.}

\item{filename}{The name of the output file where the Matrix Market formatted
data will be saved.}
}
\value{
A boolean indicating success or failure. Writes a MTX file to disk.
}
\description{
This function takes a numeric matrix and converts it into a
Matrix Market file.
}
\examples{
intmat <- matrix(c(1L, 2L, 3L, 4L), nrow = 2)
intmat_to_fmm(intmat, tempfile(fileext = ".mtx"))
}
