% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastNaiveBayes.detect_distribution.R,
%   R/fastNaiveBayes.detect_distribution.default.R
\name{fastNaiveBayes.detect_distribution}
\alias{fastNaiveBayes.detect_distribution}
\alias{fastNaiveBayes.detect_distribution.default}
\title{Distribution Detection Function}
\usage{
fastNaiveBayes.detect_distribution(x, nrows = 10)

\method{fastNaiveBayes.detect_distribution}{default}(x, nrows = 10)
}
\arguments{
\item{x}{a numeric matrix, or a dgcMatrix}

\item{nrows}{number of rows to use to detect distributions}

\item{...}{Not used.}
}
\value{
A list of distribution names mapped to column names
}
\description{
Determines which distribution to use for which columns in the matrix based
on a set of rules.
}
\details{
A simple utility function to detect the distribution to use for each columns
}
\examples{
rm(list = ls())
library(fastNaiveBayes)
cars <- mtcars
y <- as.factor(ifelse(cars$mpg > 25, "High", "Low"))
x <- cars[, 2:ncol(cars)]

# Uses default of top 10 rows to determine distributions
dist <- fastNaiveBayes.detect_distribution(x)
print(dist)

# Uses all rows of x to determine distributions
dist <- fastNaiveBayes.detect_distribution(x, nrows = nrow(x))
print(dist)
}
