% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{littleSurvey}
\alias{littleSurvey}
\title{Results from a little survey}
\format{A data frame with 279 observations on the following 20 variables.
\itemize{ \item{number}{ a number between 1 and 30}
\item{colorVer}{ which version of the 'favorite color' question was
on the survey. A factor with levels \code{v1} \code{v2}}
\item{color}{ favorite color if among predefined choices.  A factor
with levels \code{} \code{black} \code{green} \code{other} \code{purple}
\code{red}} \item{otherColor}{ favorite color if not among choices
above.} \item{animalVer}{ which version of the 'favorite color'
question was on the survey. A factor with levels \code{v1} \code{v2}}
\item{animal}{ favorite animal if among predefined choices.  A factor
with levels \code{} \code{elephant} \code{giraffe} \code{lion}
\code{other}.} \item{otherAnimal}{ favorite animal if not among the
predefined choices.} \item{pulseVer}{ which version of the 'pulse'
question was on the survey} \item{pulse}{ self-reported pulse}
\item{TVver}{ which of three versions of the TV question was on the
survey} \item{tvBox}{ a factor with levels \code{<1} \code{>4}
\code{>8} \code{1-2} \code{2-4} \code{4-8} \code{none} \code{other}}
\item{tvHours}{ a numeric vector} \item{surpriseVer}{ which of
two versions of the 'surprise' question was on the survey}
\item{surprise}{ a factor with levels \code{no} \code{yes}}
\item{playVer}{ which of two versions of the 'play' question was on
the survey} \item{play}{ a factor with levels \code{no} \code{yes}}
\item{diseaseVer}{ which of two versions of the 'play' question was
on the survey} \item{disease}{ a factor with levels \code{A}
\code{B}} \item{homeworkVer}{ which of two versions of the 'homework'
question was on the survey} \item{homework}{ a factor with levels
\code{A} \code{B}} }}
\description{
These data are from a little survey given to a number of students in
introductory statistics courses. Several of the items were prepared in
multiple versions and distributed randomly to the students.
}
\examples{
data(littleSurvey)
xtabs(~surprise+surpriseVer, data=littleSurvey)
xtabs(~disease+diseaseVer, data=littleSurvey)
}
\keyword{datasets}

