% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplot.R
\name{SSplot}
\alias{SSplot}
\title{Sum of Squares Plots}
\usage{
SSplot(
  model1,
  model2,
  n = 1,
  col1 = "gray50",
  size1 = 0.6,
  col2 = "navy",
  size2 = 1,
  col3 = "red",
  size3 = 1,
  ...,
  env = parent.frame()
)
}
\arguments{
\item{model1}{a linear model}

\item{model2}{a linear model, often using \code{\link{rand}()}.}

\item{n}{an integer specifying how many times to regenerate 
\code{model2}.}

\item{col1, col2, col3}{Colors for the line segments in the plot}

\item{size1, size2, size3}{Sizes of the line segments in the plot}

\item{...}{additional arguments (currently ignored)}

\item{env}{an environment in which to evaluate the models.}
}
\description{
This function creates plots showing the "consumption" of residual
sum of squares resulting from adding predictors to a model.
}
\examples{
  
SSplot(
  lm(strength ~ limestone + water, data = Concrete),
  lm(strength ~ limestone + rand(7), data = Concrete),
  n = 50) 
\dontrun{
SSplot(
  lm(strength ~ water + limestone, data = Concrete),
  lm(strength ~ water + rand(7), data = Concrete),
  n = 1000) 
}
}
