% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undirected_chung_lu.R
\name{chung_lu}
\alias{chung_lu}
\title{Create an undirected Chung-Lu object}
\usage{
chung_lu(
  n = NULL,
  theta = NULL,
  ...,
  sort_nodes = TRUE,
  poisson_edges = TRUE,
  allow_self_loops = TRUE,
  force_identifiability = FALSE
)
}
\arguments{
\item{n}{(degree heterogeneity) The number of nodes in the graph.
Use when you don't want to specify the degree-heterogeneity
parameters \code{theta} by hand. When \code{n} is specified, \code{theta}
is randomly generated from a \code{LogNormal(2, 1)} distribution.
This is subject to change, and may not be reproducible.
\code{n} defaults to \code{NULL}. You must specify either \code{n}
or \code{theta}, but not both.}

\item{theta}{(degree heterogeneity) A numeric vector
explicitly specifying the degree heterogeneity
parameters. This implicitly determines the number of nodes
in the resulting graph, i.e. it will have \code{length(theta)} nodes.
Must be positive. Setting to a vector of ones recovers
an erdos renyi graph.
Defaults to \code{NULL}. You must specify either \code{n} or \code{theta},
but not both.}

\item{...}{
  Arguments passed on to \code{\link[=undirected_factor_model]{undirected_factor_model}}
  \describe{
    \item{\code{expected_degree}}{If specified, the desired expected degree
of the graph. Specifying \code{expected_degree} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
    \item{\code{expected_density}}{If specified, the desired expected density
of the graph. Specifying \code{expected_density} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
  }}

\item{sort_nodes}{Logical indicating whether or not to sort the nodes
so that they are grouped by block and by \code{theta}. Useful for plotting.
Defaults to \code{TRUE}.}

\item{poisson_edges}{Logical indicating whether or not
multiple edges are allowed to form between a pair of
nodes. Defaults to \code{TRUE}. When \code{FALSE}, sampling proceeds
as usual, and duplicate edges are removed afterwards. Further,
when \code{FALSE}, we assume that \code{S} specifies a desired between-factor
connection probability, and back-transform this \code{S} to the
appropriate Poisson intensity parameter to approximate Bernoulli
factor connection probabilities. See Section 2.3 of Rohe et al. (2017)
for some additional details.}

\item{allow_self_loops}{Logical indicating whether or not
nodes should be allowed to form edges with themselves.
Defaults to \code{TRUE}. When \code{FALSE}, sampling proceeds allowing
self-loops, and these are then removed after the fact.}

\item{force_identifiability}{Logical indicating whether or not to
normalize \code{theta} such that it sums to one within each block. Defaults
to \code{FALSE}, since this behavior can be surprise when \code{theta} is set
to a vector of all ones to recover the DC-SBM case.}
}
\value{
An \code{undirected_chung_lu} S3 object, a subclass of \code{\link[=dcsbm]{dcsbm()}}.
}
\description{
To specify a Chung-Lu graph, you must specify
the degree-heterogeneity parameters (via \code{n} or \code{theta}).
We provide reasonable defaults to enable rapid exploration
or you can invest the effort
for more control over the model parameters. We \strong{strongly recommend}
setting the \code{expected_degree} or \code{expected_density} argument
to avoid large memory allocations associated with
sampling large, dense graphs.
}
\examples{

set.seed(27)

cl <- chung_lu(n = 1000, expected_density = 0.01)
cl

theta <- round(stats::rlnorm(100, 2))

cl2 <- chung_lu(
  theta = theta,
  expected_degree = 5
)

cl2

edgelist <- sample_edgelist(cl)
edgelist

}
\seealso{
Other undirected graphs: 
\code{\link{dcsbm}()},
\code{\link{erdos_renyi}()},
\code{\link{mmsbm}()},
\code{\link{overlapping_sbm}()},
\code{\link{planted_partition}()},
\code{\link{sbm}()}
}
\concept{undirected graphs}
