% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasttext.R
\name{ft_control}
\alias{ft_control}
\title{Default Control Settings}
\usage{
ft_control(
  loss = c("softmax", "hs", "ns"),
  learning_rate = 0.05,
  learn_update = 100L,
  word_vec_size = 100L,
  window_size = 5L,
  epoch = 5L,
  min_count = 5L,
  min_count_label = 0L,
  neg = 5L,
  max_len_ngram = 1L,
  nbuckets = 2000000L,
  min_ngram = 3L,
  max_ngram = 6L,
  nthreads = 1L,
  threshold = 1e-04,
  label = "__label__",
  verbose = 0,
  pretrained_vectors = "",
  output = "",
  save_output = FALSE,
  seed = 0L,
  qnorm = FALSE,
  retrain = FALSE,
  qout = FALSE,
  cutoff = 0L,
  dsub = 2L,
  autotune_validation_file = "",
  autotune_metric = "f1",
  autotune_predictions = 1L,
  autotune_duration = 300L,
  autotune_model_size = ""
)
}
\arguments{
\item{loss}{a character string giving the name of the loss function 
allowed values are \code{'softmax'}, \code{'hs'} and \code{'ns'}.}

\item{learning_rate}{a numeric giving the learning rate, the default value is \code{0.05}.}

\item{learn_update}{an integer giving after how many tokens the learning rate
should be updated. The default value is \code{100L}, which
means the learning rate is updated every 100 tokens.}

\item{word_vec_size}{an integer giving the length (size) of the word vectors.}

\item{window_size}{an integer giving the size of the context window.}

\item{epoch}{an integer giving the number of epochs.}

\item{min_count}{an integer giving the minimal number of word occurences.}

\item{min_count_label}{and integer giving the minimal number of label occurences.}

\item{neg}{an integer giving how many negatives are sampled (only used if loss is \code{"ns"}).}

\item{max_len_ngram}{an integer giving the maximum length of ngrams used.}

\item{nbuckets}{an integer giving the number of buckets.}

\item{min_ngram}{an integer giving the minimal ngram length.}

\item{max_ngram}{an integer giving the maximal ngram length.}

\item{nthreads}{an integer giving the number of threads.}

\item{threshold}{a numeric giving the sampling threshold.}

\item{label}{a character string specifying the label prefix (default is \code{'__label__'}).}

\item{verbose}{an integer giving the verbosity level, the default value
is \code{0L} and shouldn't be changed since Rcpp::Rcout 
cann't handle the traffic.}

\item{pretrained_vectors}{a character string giving the file path
to the pretrained word vectors which are used 
for the supervised learning.}

\item{output}{a character string giving the output file path.}

\item{save_output}{a logical (default is \code{FALSE})}

\item{seed}{an integer}

\item{qnorm}{a logical (default is \code{FALSE})}

\item{retrain}{a logical (default is \code{FALSE})}

\item{qout}{a logical (default is \code{FALSE})}

\item{cutoff}{an integer (default is \code{0L})}

\item{dsub}{an integer (default is \code{2L})}

\item{autotune_validation_file}{a character string}

\item{autotune_metric}{a character string (default is \code{"f1"})}

\item{autotune_predictions}{an integer (default is \code{1L})}

\item{autotune_duration}{an integer (default is \code{300L})}

\item{autotune_model_size}{a character string}
}
\value{
a list with the control variables.
}
\description{
A auxiliary function for defining the control variables.
}
\examples{
ft_control(learning_rate=0.1)
}
