% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation-impute.R
\name{citation_impute}
\alias{citation_impute}
\alias{citation_impute.sparseMatrix}
\alias{citation_impute.LRMF}
\title{CitationImpute}
\usage{
citation_impute(
  X,
  rank,
  ...,
  initialization = c("svd", "adaptive-initialize", "approximate"),
  max_iter = 200L,
  check_interval = 1L,
  epsilon = 1e-07,
  additional = NULL
)

\method{citation_impute}{sparseMatrix}(
  X,
  rank,
  ...,
  initialization = c("svd", "adaptive-initialize", "approximate"),
  additional = NULL
)

\method{citation_impute}{LRMF}(
  X,
  rank,
  ...,
  epsilon = 1e-07,
  max_iter = 200L,
  check_interval = 1L
)
}
\arguments{
\item{X}{A \emph{square} sparse matrix of \code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}} class.
Implicit zeros in the upper triangle of this matrix are considered
observed and predictions on these elements contribute to the
objective function minimized by \code{AdaptiveImpute}.}

\item{rank}{Desired rank (integer) to use in the low rank approximation.
Must be at least \code{2L} and at most the rank of \code{X}. Note that the rank
of \code{X} is typically unobserved and computations may be unstable or
even fail when \code{rank} is near or exceeds this threshold.}

\item{...}{Unused additional arguments.}

\item{initialization}{How to initialize the low rank approximation.
Options are:
\itemize{
\item \code{"svd"} (default). In the initialization step, this treats
unobserved values as zeroes.
\item \code{"adaptive-initialize"}. In the initialization step, this treats
unobserved values as actually unobserved. However, the current
\code{AdaptiveInitialize} implementation relies on dense matrix
computations that are only suitable for relatively small matrices.
\item \code{"approximate"}. An approximate variant of \code{AdaptiveInitialize}
that is less computationally expensive. See \code{adaptive_initialize}
for details.
}

Note that initialization matters as \code{AdaptiveImpute} optimizes
a non-convex objective. The current theory shows that initializing
with \code{AdaptiveInitialize} leads to a consistent estimator, but it
isn't know if this is the case for SVD initialization. Empirically
we have found that SVD initialization works well nonetheless.}

\item{max_iter}{Maximum number of iterations to perform (integer). Defaults
to \code{200L}. In practice 10 or so iterations will get you a decent
approximation to use in exploratory analysis, and and 50-100 will get
you most of the way to convergence. Must be at least \code{1L}.}

\item{check_interval}{Integer specifying how often to perform convergence
checks. Defaults to \code{1L}. In practice, check for convergence requires
a norm calculation that is expensive for large matrices and decreasing
the frequency of convergence checks will reduce computation time. Can
also be set to \code{NULL}, which case \code{max_iter} iterations of the algorithm
will occur with no possibility of stopping due to small relative change
in the imputed matrix. In this case \code{delta} will be reported as \code{Inf}.}

\item{epsilon}{Convergence criteria, measured in terms of relative change
in Frobenius norm of the full imputed matrix. Defaults to \code{1e-7}.}

\item{additional}{Ignored except when \code{alpha_method = "approximate"}
in which case it controls the precise of the approximation to \code{alpha}.
The approximate computation of \code{alpha} will always understand \code{alpha},
but the approximation will be better for larger values of \code{additional}.
We recommend making \code{additional} as large as computationally tolerable.}
}
\value{
A low rank matrix factorization represented by an
\code{\link[=adaptive_imputation]{adaptive_imputation()}} object.
}
\description{
An implementation of the \code{AdaptiveImpute} algorithm using efficient
sparse matrix computations, specialized for the case when missing
values in the upper triangle are taken to be \emph{explicitly observed}
zeros, as opposed to missing values. This is primarily
useful for spectral decompositions of adjacency matrices of graphs
with (near) tree structure, such as citation networks.
}
\details{
If OpenMP is available, \code{citation_impute} will automatically
use \code{getOption("Ncpus", 1L)} OpenMP threads to parallelize some
key computations. Note that some computations are performed with
the Armadillo C++ linear algebra library and may also be parallelized
dependent on your BLAS and LAPACK installations and configurations.
}
\examples{

# create a (binary) square sparse matrix to demonstrate on

set.seed(887)

n <- 10
A <- rsparsematrix(n, n, 0.1, rand.x = NULL)

mf <- citation_impute(A, rank = 3L, max_iter = 1L, check_interval = NULL)
mf


}
