\name{NEWS}
\title{News for \R{} Package \pkg{fastbeta}}

\section{Changes in version 0.2.0 (2023-12-11)}{
  \itemize{
    \item Backwards incompatible changes to the API partly due to
    generalization allowing for loss of immunity:
    \itemize{
      \item \code{sir}
      expects \code{constants = c(S0, I0, R0, gamma, delta)},
      no longer \code{constants = c(gamma, S0, I0, R0)}.

      \item \code{fastbeta} and \code{fastbeta.bootstrap}
      expect \code{constants = c(S0, I0, R0, gamma, delta)},
      no longer \code{constants = c(gamma, S0, I0)}.

      \item \code{fastbeta} returns (modulo attributes)
      \code{cbind(S, I, R, beta)}, no longer \code{cbind(beta, S, I)}.

      \item \code{ptpi} gains argument \code{constants} and loses
      argument \code{start}.
      It expects \code{constants = c(Sa, Ia, Ra, gamma, delta)},
      no longer \code{start = Sa}.

      \item \code{ptpi(\dots)[[1L]]} gives the state at time \code{0}
      or at time \code{a} conditional on new argument \code{backcalc}.
      The default is \code{a}, no longer (implicitly) \code{0}.

      \item \code{ptpi(\dots)[[4L]]} has dimensions
      \code{c(b-a+1, 3, iter)}, no longer \code{c(b-a+1, iter)}.
    }

    \item \file{data/*.R} are no longer copied into \file{inst/scripts}
    at install time by a \command{make} rule in \file{src/Makevars}.
    There is no need: the scripts are preserved due to the setting of
    \code{BuildResaveData: no}.  Hence \file{src/Makevars} is removed.

    \item Simulation \code{sir.e01} is generated by the same parameters
    but is no longer stochastic.  Simulation \code{sir.e02} gives the
    stochastic variant.
  }
}

\section{Changes in version 0.1.1 (2023-11-28)}{
  \itemize{
    \item Changes are logged in \file{inst/NEWS.Rd}.

    \item \code{Depends: R (>= 4.3.0)} for \verb{amsmath} in PDF
    output, which was not supported until 4.2.2.

    \item \file{DESCRIPTION} sets \code{BuildResaveData: no},
    so that \command{R CMD build} works without
    \option{--no-resave-data} when \pkg{fastbeta} is not installed.

    \item \file{data/*.R} are copied into \file{inst/scripts}
    at install time by a \command{make} rule in \file{src/Makevars}.

    \item Typo in \file{src/sir.c} triggering \option{-Wformat}
    is fixed.
  }
}
