% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceControl.R
\name{varianceControl}
\alias{varianceControl}
\title{Controls for Variance Calculation}
\usage{
varianceControl(B = 100L, seed = 1991L, useMultipleCores = FALSE)
}
\arguments{
\item{B}{Integer: Number of bootstrap samples needed for variance estimation.}

\item{seed}{Integer: Seed value for bootstrapping. Results may differ if parallelized.}

\item{useMultipleCores}{Logical: Set to TRUE if parallelizing. (Default is FALSE).}
}
\value{
Returns a list for variance options inputted into \code{fastCrr}.
\item{B}{same as what is defined in function.}
\item{seed}{same as what is defined in function.}
\item{useMultipleCores}{same as what is defined in function.}
}
\description{
Controls for variance calculation for the fastcmprsk package.
}
\details{
Variance-covariance estimation is done via bootstrap.
Independent bootstrap runs can be performed both in serial and parallel. Parallelization is done via the
\code{doParallel} package.
}
\examples{

library(fastcmprsk)
set.seed(10)
ftime <- rexp(200)
fstatus <- sample(0:2, 200, replace = TRUE)
cov <- matrix(runif(1000), nrow = 200)
dimnames(cov)[[2]] <- c('x1','x2','x3','x4','x5')
vc <- varianceControl(B = 100, seed = 2019, useMultipleCores = FALSE)
fit1 <- fastCrr(Crisk(ftime, fstatus) ~ cov, variance = TRUE, var.control = vc)
fit1$var # Estimated covariance matrix via bootstrap

}
