% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.r
\name{flow,GRaster-method}
\alias{flow,GRaster-method}
\alias{flow}
\title{Identify watershed basins and direction and accumulation of flow}
\usage{
\S4method{flow}{GRaster}(
  x,
  direction = "multi",
  return = "accumulation",
  dirThreshold = Inf,
  scratchDir = NULL
)
}
\arguments{
\item{x}{A \code{GRaster} with a single layer, typically representing elevation.}

\item{direction}{Character: Either \code{"single"} or \code{"multi"}. This indicates whether a single-direction flow or multi-direction flow model is used. The default is \code{"multi"}. Partial matching is used and case is ignored.}

\item{return}{Character vector: Indicates what rasters to return. Partial matching is used and case is ignored. Options include:
\itemize{
\item \code{"accumulation"} (default): Flow accumulation raster.
\item \code{"basins"}: Watershed basins
\item \code{"direction"}: Flow direction
\item \code{"flooded"}: Flooded areas
\item \code{"TCI"}: Topographic convergence index
\item \code{"*"}: All of the above
}}

\item{dirThreshold}{Numeric (default is \code{Inf}): For the multi-direction flow model, this indicates the amount of accumulated flow above which the single-direction flow rule is used to locate the egress of water from a cell. This is the \code{d8cut} parameter in \code{r.stream.extract}.}

\item{scratchDir}{Character or \code{NULL} (default): Directory in which to store temporary files. The \strong{GRASS} module \code{r.terraflow} makes a lot of temporary files. If this is \code{NULL}, then a temporary folder in the user's working directory will be used (see \code{\link[=getwd]{getwd()}}).}
}
\value{
A \code{GRaster}.
}
\description{
The \code{flow()} function uses a raster representing elevation to compute other rasters representing:
\itemize{
\item Flow accumulation;
\item Direction of flow;
\item Watershed basins;
\item Flooded areas; and/or
\item Topographic convergence (log of flow accumulation divided by local slope).
}

More details about the computations can be found at the help page for the \strong{GRASS} module \code{r.terraflow}] (see \code{grassHelp("r.terraflow")})
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")
elev <- fast(madElev)

# Calculate flow accumulation and watershed basins
water <- flow(elev, return = c("accum", "basins"))
water

elevWater <- c(elev, water)
plot(elevWater)

}
}
\seealso{
\code{\link[=flowPath]{flowPath()}}, \code{\link[=streams]{streams()}}, the \strong{GRASS} module \code{r.terraflow} (see \code{grassHelp("r.terraflow")})
}
