% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layerCor.r
\name{layerCor,GRaster-method}
\alias{layerCor,GRaster-method}
\alias{layerCor}
\title{Correlation between GRasters}
\usage{
\S4method{layerCor}{GRaster}(x, fun = "cor")
}
\arguments{
\item{x}{A \code{GRaster} with two or more layers.}

\item{fun}{Character: Name of the statistic to calculate; either \code{"cor"} (default) or \code{"cov"}.}
}
\value{
A numeric \code{matrix}.
}
\description{
This function returns a correlation or covariance matrix between two or more \code{GRaster} layers. This function returns the sample correlation and covariance (i.e., the denominator is n - 1).
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madChelsa <- fastData("madChelsa")

# Convert a SpatRaster to a GRaster:
chelsa <- fast(madChelsa)

# Correlation
layerCor(chelsa, "cor")

# Covariance
layerCor(chelsa, "cov")

}
}
\seealso{
\code{\link[terra:layerCor]{terra::layerCor()}}, \code{\link[stats:cor]{stats::cor()}}, \code{\link[stats:cor]{stats::cov()}}
}
