% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/princomp.r
\name{princomp,GRaster-method}
\alias{princomp,GRaster-method}
\alias{princomp}
\title{Apply a principal component analysis (PCA) to layers of a GRaster}
\usage{
\S4method{princomp}{GRaster}(x, scale = TRUE, scores = FALSE)
}
\arguments{
\item{x}{A \code{GRaster} with two or more layers.}

\item{scale}{Logical: If \code{TRUE} (default), input layers will be rescaled by dividing each layer by its overall population standard deviation. Rasters will always be centered (have their mean subtracted from values). Centering and scaling is recommended when rasters values are in different units.}

\item{scores}{Logical: If \code{TRUE}, the \code{prcomp} object will have the scores attached to it. This can greatly increase the size of the object in memory if the input raster has many cells. It will also take more time. If \code{FALSE} (default), then skip returning scores.}
}
\value{
A multi-layer \code{GRaster} with one layer per principal component axis. The \code{\link[=pcs]{pcs()}} function can be used on the output raster to retrieve a \code{prcomp} object from the raster, which includes rotations (loadings) and proportions of variance explained.
}
\description{
This function applies a principal component analysis to layers of a \code{GRaster}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Climate raster:
madChelsa <- fastData("madChelsa")

# Convert a SpatRaster to a GRaster:
chelsa <- fast(madChelsa)

# Generate raster with layers representing principal component predictions:
pcRast <- princomp(chelsa, scale = TRUE)
plot(pcRast)

# Get information on the PCA:
prinComp <- pcs(pcRast)

prinComp
summary(prinComp)
plot(prinComp)

}
}
\seealso{
\code{\link[terra:princomp]{terra::princomp()}}, \code{\link[terra:prcomp]{terra::prcomp()}}
}
