% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wetness.r
\name{wetness,GRaster-method}
\alias{wetness,GRaster-method}
\alias{wetness}
\title{Topographic wetness index}
\usage{
\S4method{wetness}{GRaster}(x)
}
\arguments{
\item{x}{A \code{GRaster} (typically representing elevation). The raster must be projected (i.e., not in WGS84, NAD83, et cetera).}
}
\value{
A \code{GRaster}.
}
\description{
This function creates a raster map with values equal to the topographic wetness index (TWI), which is a measure of how much overland water flow tends to accumulate in or flow away from a location.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert to GRaster:
elev <- fast(madElev)

# Terrain ruggedness index:
tri <- ruggedness(elev)
plot(c(elev, tri))

# Topographic wetness index:
twi <- wetness(elev)
plot(c(elev, twi))

}
}
\seealso{
\code{\link[=terrain]{terrain()}}, \code{\link[=ruggedness]{ruggedness()}}, \code{\link[=geomorphons]{geomorphons()}}, \strong{GRASS} manual for module \code{r.topidx} (see \code{grassHelp("r.topidx")})
}
