% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomtype.r
\name{geomtype,GVector-method}
\alias{geomtype,GVector-method}
\alias{geomtype}
\alias{is.points,GVector-method}
\alias{is.points}
\alias{is.lines,GVector-method}
\alias{is.lines}
\alias{is.polygons,GVector-method}
\alias{is.polygons}
\title{Geometry of a GVector (points, lines, or polygons)}
\usage{
\S4method{geomtype}{GVector}(x, grass = FALSE)

\S4method{is.points}{GVector}(x)

\S4method{is.lines}{GVector}(x)

\S4method{is.polygons}{GVector}(x)
}
\arguments{
\item{x}{A \code{GVector}.}

\item{grass}{Logical: If \code{FALSE} (default), return \strong{terra}-like geometry types ("points", "lines", or "polygons"). If \code{TRUE}, return \strong{GRASS}-like geometry types ("point", "line", "area"--note that these are a subset of the available types and may not be the "true" \strong{GRASS} type).}
}
\value{
\code{geomtype()} returns either "points", "lines", or "polygons" if the \code{grass} arguments is \code{FALSE}, or "point", "line", "area" if \code{grass} is \code{TRUE}. The "\verb{is.*}" functions return \code{TRUE} or \code{FALSE}.
}
\description{
\code{geomtype()} reports whether a \code{GVector} represents points, lines, or polygons. The "\verb{is.*}" functions test whether the \code{GVector} represents points, lines, or polygons.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Example data:
madCoast4 <- fastData("madCoast4")
madRivers <- fastData("madRivers")
madDypsis <- fastData("madDypsis")

# Convert sf vectors to GVectors:
coast <- fast(madCoast4)
rivers <- fast(madRivers)
dypsis <- fast(madDypsis)

# Geographic properties:
ext(rivers) # extent
crs(rivers) # coordinate reference system
st_crs(rivers) # coordinate reference system
coordRef(rivers) # coordinate reference system

# Column names and data types:
names(coast)
datatype(coast)

# Points, lines, or polygons?
geomtype(dypsis)
geomtype(rivers)
geomtype(coast)

is.points(dypsis)
is.points(coast)

is.lines(rivers)
is.lines(dypsis)

is.polygons(coast)
is.polygons(dypsis)

# Number of dimensions:
topology(rivers)
is.2d(rivers) # 2-dimensional?
is.3d(rivers) # 3-dimensional?

# Just the data table:
as.data.frame(rivers)
as.data.table(rivers)

# Top/bottom of the data table:
head(rivers)
tail(rivers)

# Vector or table with just selected columns:
names(rivers)
rivers$NAME
rivers[[c("NAM", "NAME_0")]]
rivers[[c(3, 5)]]

# Select geometries/rows of the vector:
nrow(rivers)
selected <- rivers[2:6]
nrow(selected)

# Plot:
plot(coast)
plot(rivers, col = "blue", add = TRUE)
plot(selected, col = "red", lwd = 2, add = TRUE)

# Vector math:
hull <- convHull(dypsis)

un <- union(coast, hull)
sameAsUnion <- coast + hull
plot(un)
plot(sameAsUnion)

inter <- intersect(coast, hull)
sameAsIntersect <- coast * hull
plot(inter)
plot(sameAsIntersect)

er <- erase(coast, hull)
sameAsErase <- coast - hull
plot(er)
plot(sameAsErase)

xr <- xor(coast, hull)
sameAsXor <- coast / hull
plot(xr)
plot(sameAsXor)

# Vector area and length:
expanse(coast, unit = "km") # polygons areas
expanse(rivers, unit = "km") # river lengths

### Fill holes

# First, we will make some holes by creating buffers around points.
buffs <- buffer(dypsis, 500)

holes <- coast - buffs
plot(holes)

filled <- fillHoles(holes, fail = FALSE)

}
}
\seealso{
\code{\link[terra:geomtype]{terra::geomtype()}}
}
