% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpe.R
\name{hpe}
\alias{hpe}
\title{H+ discordance metric}
\usage{
hpe(A, B, D, L, p = 101, alg = "brute_force", alpha = F, gammas = F)
}
\arguments{
\item{A}{numeric vector containing a set of length n}

\item{B}{numeric vector containing a set of length n}

\item{D}{distance matrix of dimension nxn}

\item{L}{numeric or character vector of length n}

\item{p}{integer representing the number of percentiles}

\item{alg}{character string ("brute_force" or "grid_search") representing the choice of algorithm used to estimate H+}

\item{alpha}{logical indicator to return alpha values that parameterize balance of within/between cluster distances}

\item{gammas}{logical indicator to return estimate for gamma values that parameterize what \%Dw is greater than a second \%Db}
}
\value{
h is the estimated H+ value.

(optional) aw and ab (alphaW and alphaB) are (respectively) the portion of within- and between-cluster distances (or portional sizes of A and B)

(optional) gw and gb (gammaW and gammaB) are plausible ranges for gw\emph{100\% of Dw (or A) are strictly greater than gw}100\% Db (or B)
}
\description{
Estimates the H+ discordance metric
for either (1) two sets (vectors) A and B, or
(2) a dissimilarity matrix D and a label vector L.
Approximation is calculated using p+1 percentiles,
with an accuracy bound of 1/p.
}
\examples{
a <- rnorm(n=500, mean=0)
b <- rnorm(n=500 ,mean=1)
h <- hpe(A=a, B=b, p=101, alg="brute_force")

a <- sapply(1:500, function(i) rnorm(n=50, mean=0))
b <- sapply(1:500, function(i) rnorm(n=50, mean=0))
x <- cbind(a,b)
d <- dist(t(x))
l <- c(rep(0,500), rep(1,500))
h <- hpe(D=d, L=l, p=101, alg="brute_force")

}
